<?php
session_start();
require_once './config/config.php';
require_once 'includes/auth_validate.php';

//Only super admin is allowed to access this page
if ($_SESSION['admin_type'] !== 'super') {
    // show permission denied message
    echo 'Permission Denied';
    exit();
}


if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    $data_to_store = filter_input_array(INPUT_POST);
    $db = getDbInstance();
    
    // Check whether the username already exists
    $db->where('user_name', $data_to_store['user_name']);
    $db->get('admin_accounts');
    
    if ($db->count >= 1) {
        $_SESSION['failure'] = "Username already exists";
        header('location: add_admin.php');
        exit();
    }

    // Encrypt password
    $data_to_store['password'] = password_hash($data_to_store['password'], PASSWORD_DEFAULT);

    // Ensure 'id' is not included if it's AUTO_INCREMENT
    unset($data_to_store['id']);

    // Insert into the database
    $db = getDbInstance();
    $last_id = $db->insert('admin_accounts', $data_to_store);

    if ($last_id) {
        $_SESSION['success'] = "Admin user added successfully!";
        header('location: admin_users.php');
        exit();
    } else {
        $_SESSION['failure'] = "Failed to add admin user.";
        header('location: add_admin.php');
        exit();
    }
}


$edit = false;


require_once 'includes/header.php';
?>
<div id="page-wrapper">
	<div class="row">
		<div class="col-lg-12">
			<h2 class="page-header">Add User</h2>
		</div>
	</div>
	 <?php 
    include_once('includes/flash_messages.php');
    ?>
	<form class="well form-horizontal" action=" " method="post"  id="contact_form" enctype="multipart/form-data">
		<?php include_once './forms/admin_users_form.php'; ?>
	</form>
</div>




<?php include_once 'includes/footer.php'; ?>