<?php

/**
 * this method is automatically accessible as
 *     http://example.com/amember/ahrefs/admin
 * all controllers with names starting with "admin" 
 * will automatically require admin login and you
 * have to define checkPermissions method in controller
 */
class Ahrefs_AdminController extends Am_Controller 
{
    public function checkAdminPermissions(Admin $admin)
    {
        return $admin->isSuper(); // only super-admins allowed to open this
    }
    
    function indexAction() {
        $GLOBALS['ahrefsResetAllUsersUrl'] = $resetAllUsersUrl = $this->getDi()->url('ahrefs/admin/reset-limit-counters');
        $GLOBALS['ahrefsResetUserUrl'] = $this->getDi()->url('ahrefs/admin/user-reset-limit-counters');
        $GLOBALS['ahrefsBackToUrl'] = urlencode($this->getDi()->url('ahrefs/admin'));

        //$this->view->headScript()->appendFile($this->view->_scriptJs('ngrid.js'))->appendScript('jQuery(function($){$(".grid-wrap").ngrid();});');
        // add query class to fetch records for grid
        $ds = new Am_Query($this->getDi()->userTable);

        // define the grid
        $grid = new Am_Grid_ReadOnly('_ahrefs', 'Ahrefs usage', $ds, $this->_request, $this->view);

        $filter = new Am_Grid_Filter_Text('User', 'login');
        $filter->initFilter($grid);
        $grid->setFilter($filter);
        // define fields
        $grid->addField('login', 'User')->setRenderFunction(function($r, $fn, $g, $fo){
            $resetAllUsersUrl = $GLOBALS['ahrefsResetAllUsersUrl'];
            $resetUserUrl = $GLOBALS['ahrefsResetUserUrl'];
            $backToUrl = $GLOBALS['ahrefsBackToUrl'];

            $resetAllContainer = <<<EOS
<div style="border: none; margin-bottom: 5px;" id="mco-reset-btn-container"><a class="button" id="ahrefs-reset-btn" href="$resetAllUsersUrl">Reset all counters >></a></div>
EOS;

            $htmlBlock = <<<EOS
<script type="text/javascript">
$(document).ready(function() {
    var resetButtonContainerId = $("#mco-reset-btn-container");
    if (resetButtonContainerId.length === 0) {
        var gridContainer = $(".am-grid-container");
        gridContainer.eq(0).before($('$resetAllContainer'));
    }
});
</script>
EOS;
            $link = <<<EOS
<a href="$resetUserUrl?user=$r->user_id&goto=$backToUrl" target="_top">
$r->login</a>
EOS;
            return "<td>$link $htmlBlock</td>";
        });
        $grid->addField('ahrefs_usage_left_count', 'Left')->setRenderFunction(function($r, $fn, $g, $fo){
            $limit = $r->ahrefs_usage_limit > 0 ? $r->ahrefs_usage_limit : Am_Di::getInstance()->config->get('ahrefs.usage_limit');
            
            $left = $limit;
        	$today = date('Y-m-d');
        	if($r->ahrefs_usage_start_date==$today){
                $history = empty($r->ahrefs_usage_history) ? [] : json_decode($r->ahrefs_usage_history);
                $todayCount = count(json_decode($r->ahrefs_usage_history, TRUE));
                $left = $limit - $todayCount;
        	}
            return sprintf('<td><strong>%s</strong></td>', $left);
        });
        
        $grid->addField('ahrefs_usage_history', 'History')->setRenderFunction(function($r, $fn, $g, $fo){
            $todayCount = 0;
        	$today = date('Y-m-d');
        	if($r->ahrefs_usage_start_date==$today){
                $history = empty($r->ahrefs_usage_history) ? [] : json_decode($r->ahrefs_usage_history);
                $todayCount = count(json_decode($r->ahrefs_usage_history, TRUE));
        	}
            return sprintf('<td>%s</td>', $todayCount);
        });
        $grid->addField('ahrefs_usage_total_count', 'Total');

        $grid->addField('ahrefs_usage_limit', 'Limit')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td><strong>%s</strong></td>', Am_Di::getInstance()->config->get('ahrefs.usage_limit'));
        });

        $grid->addField('ahrefs_usage_last_date', 'Next reset date')->setRenderFunction(function($r, $fn, $g, $fo){
            $formattedDate = '-';
            if (! is_null($r->ahrefs_usage_start_date)) {
                $date = date_create($r->ahrefs_usage_start_date);
                $date->add(new DateInterval('P1M'));
                $formattedDate = date_format($date, 'd/m/Y');
            }

            return sprintf('<td>%s</td>', $formattedDate);
        });

        $this->view->title = "Ahrefs usage";

        //$this->view->content = $htmlBlock . $grid->render();
        //$this->view->content = $htmlBlock;

        // run grid actions wrapped to layout.phtml
        $grid->runWithLayout('admin/layout.phtml');

        //$this->view->display('admin/layout.phtml'); // lay it out to admin header/footer
    }


    function resetLimitCountersAction()
    {
        $sqlStmt = <<<EOS
UPDATE ?_user SET ahrefs_usage_history = ?, ahrefs_usage_start_date = ?, ahrefs_usage_total_count = ?
EOS;

        $users = $this->getDi()->db->query($sqlStmt,
            json_encode([]), null, 0);
        $redirectUrl = $this->getDi()->url('ahrefs/admin');
        if (isset($_GET['goto']) && is_string($_GET['goto']))
            $redirectUrl = urldecode($_GET['goto']);
        header("Location: $redirectUrl");
        exit;
    }


    function userResetLimitCountersAction()
    {
        $sqlStmt = <<<EOS
UPDATE ?_user SET ahrefs_usage_history = ?, ahrefs_usage_start_date = ?, ahrefs_usage_total_count = ? WHERE user_id = ?
EOS;
        if (isset($_GET["user"]) && is_string($_GET["user"])) {
            $users = $this->getDi()->db->query($sqlStmt,
                json_encode([]), null, 0,
                $_GET["user"]);
        }

        $redirectUrl = $this->getDi()->url('ahrefs/admin');
        if (isset($_GET['goto']) && is_string($_GET['goto']))
            $redirectUrl = urldecode($_GET['goto']);
        header("Location: $redirectUrl");
        exit;
    }

    function createForm()
    {
        $form = new Am_Form;
        $form->addText('user_id', 'size=60')->setLabel("Name")->addRule('required');
        $form->addText('last_date', 'size=60')->setLabel("Name")->addRule('required');
        $form->addText('left_count', 'size=60')->setLabel("Left Count")->addRule('required');
        $form->addText('total_count', 'size=60')->setLabel("Total Count")->addRule('required');
        $form->addText('targets', 'size=60')->setLabel("Targets")->addRule('required');
        return $form;
    }
}