<?php

/**
 * This sample shows how to use aMember api magic to create ajaxified 
 * CRUD grid with only one page of code
 */
class Ahrefs_GridController extends Am_Controller
{
    function indexAction()
    {
        /// add necessary javascript
        $this->view->headScript()
            ->appendFile($this->view->_scriptJs('ngrid.js'))
            ->appendScript('jQuery(function($){$(".grid-wrap").ngrid();});');
        // add query class to fetch records for grid
        $ds = new Am_Query($this->getDi()->ahrefsTable);
        // define the grid
        $grid = new Am_Grid_Editable('_ahrefs', 'Ahrefs', $ds, $this->_request, $this->view);
        $grid->setForm(array($this, 'createForm'));
        // define fields
        $grid->addField('user_id', 'User');
        $grid->addField('last_date', 'Last Search');
        $grid->addField('left_count', 'Left Count');
        $grid->addField('total_count', 'Total Count');
        $grid->addField('targets', 'Targets');
        // run grid actions wrapped to layout.phtml
        $grid->runWithLayout('layout.phtml');
    }
    
    function createForm()
    {
        $form = new Am_Form;
        // add first field with validation rules
        $t = $form->addText('title', 'size=60')->setLabel("Title\nhere you enter title");
        $t->addRule('required');
        $t->addRule('regex', 'Only alphanumeric values accepted', '/^[A-Za-z0-9]+$/');
        // add second field
        $c = $form->addTextarea('comment', 'rows=3 cols=60')->setLabel("Comment\nhere you enter comment");
        return $form;
    }
}