<?php
/**
 * Class represents records from table pages
 * {autogenerated}
 * @property int $page_id
 * @property string $title
 * @property string $desc
 * @property string $path
 * @property int $use_layout
 * @property string $html
 * @property datetime $dattm
 * @see Am_Table
 */
class Page extends ResourceAbstract
{
    public function getUrl()
    {
        return $this->path ?
            $this->getDi()->url("page/" . urlencode($this->path), null, false) :
            $this->getDi()->url("content/p/id/" . $this->page_id."/",null,false);
    }

    public function render(Am_View $view, $user = null, $use_layout = true)
    {
        $html = $this->html;

        $t = new Am_SimpleTemplate();
        if ($user)
            $t->assign('user', $user);
        $t->assignStdVars();

        $e = new Am_Event_PageBeforeRender(Am_Event::PAGE_BEFORE_RENDER, [
            'template' => $t,
            'user' => $user,
            'page' => $this,
            'html' => $html,
        ]);
        $this->getDi()->hook->call($e);

        $html = $t->render($e->getHtml());

        if ($use_layout && $this->use_layout) {
            $view->page = $this;
            $view->content = '<div class="am-content-page">' . $html . '</div>';
            $view->title = ___($this->title);
            $view->meta_title = ___($this->meta_title ? $this->meta_title : $this->title);
            if ($this->meta_keywords)
                $view->headMeta()->setName('keywords', $this->meta_keywords);
            if ($this->meta_description)
                $view->headMeta()->setName('description', $this->meta_description);
            if ($this->meta_robots)
                $view->headMeta()->setName('robots', $this->meta_robots);

            return $view->render($this->tpl ? $this->tpl : (is_bool($use_layout) ? 'layout.phtml' : $use_layout));
        } else
            return $html;
    }
}

class PageTable extends ResourceAbstractTable {
    protected $_key = 'page_id';
    protected $_table = '?_page';
    protected $_recordClass = 'Page';

    public function getAccessType()
    {
        return ResourceAccess::PAGE;
    }
    public function getAccessTitle()
    {
        return ___('Pages');
    }
    public function getPageId()
    {
        return 'pages';
    }
}
