<?php

class Bootstrap_Ahrefs extends Am_Module
{
    public function onInitFinished()
    {
        Am_Di::getInstance()->hook->add(Am_Event::ADMIN_MENU, function (Am_Event $event) {
            $menu = $event->getMenu();
            $params = [
                'label' => ___('Ahrefs'),
                'uri' => '#',
                'id' => 'ahrefs',
                'order' => 2,
                'pages' => [
                    [
                        'label' => ___('Usage'),
                        'uri' => $this->getDi()->url('ahrefs/admin'),
                        'id' => 'ahrefs-usage'
                    ]
                ]
            ];
            $menu->addPage($params);
        });
        // you can add new routes in this method
    }
    
    protected function _initSetupForm(Am_Form_Setup $form)
    {
        // here you can define configuration form 
        // if defined, it will appear at aMember Cp -> Setup -> Ahrefs
        $form->addText('ahrefs.usage_limit')
            ->setLabel('Ahrefs Usage Limit')
            ->addRule('required');
            
        $form->addText('ahrefs.redirect',['size' => 100])
            ->setLabel('Ahrefs Redirect')
            ->addRule('required');
        // this field may be accessed as 
        // $this->getConfig('limit') - from this class
        // $this->getModule()->getConfig('limit') - from this module controllers
        // Am_Di::getInstance()->config->get('ahrefs.limit') - from any point of the aMember
        
    }

    /**
     * You may hook to any event define in amember/library/Am/Event.php file
     * just define in this class a function named onEventName()
     * you may var_dump($event); to see what variables is present in the event
     */
    function onUserAfterDelete(Am_Event $event)
    {
        $user = $event->getUser();
        $table = $this->getDi()->ahrefsTable;
        $table->load($user->user_id)->delete();
        // $this->getDi()->errorLogTable->log("DEBUG: ahrefs module: user deleted" . json_encode($user));
    }

    function onGetApiControllers(Am_Event $e)
    {
        $list = $e->getList();
        $list->addController('ahrefs-check', 'ahrefs-check', ['check'], 'Ahrefs Check', 'ahrefs');

    }
}