<?php
require_once 'config/config.php';

// File-based deduplication function
function isDuplicateRequest($amember) {
    $lockDir = 'api_locks/';
    if (!file_exists($lockDir)) {
        mkdir($lockDir, 0777, true);
    }
    
    $lockFile = $lockDir . md5($amember) . '.lock';
    $currentTime = time();
    
    // Check if lock file exists and is recent (within 30 seconds)
    if (file_exists($lockFile)) {
        $lockTime = (int)file_get_contents($lockFile);
        if (($currentTime - $lockTime) < 30) {
            error_log("FILE LOCK: Duplicate request blocked for: " . $amember . " | Lock age: " . ($currentTime - $lockTime) . "s");
            return true; // This is a duplicate
        }
    }
    
    // Create/update lock file with current timestamp
    file_put_contents($lockFile, $currentTime);
    error_log("FILE LOCK: Created lock for: " . $amember . " | Time: " . $currentTime);
    
    // Clean up old lock files (older than 60 seconds)
    $files = glob($lockDir . '*.lock');
    foreach ($files as $file) {
        if (file_exists($file)) {
            $fileTime = (int)file_get_contents($file);
            if (($currentTime - $fileTime) > 60) {
                unlink($file);
            }
        }
    }
    
    return false; // This is not a duplicate
}

$totallimit = 40;
$db = getDbInstance();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    $data_to_store = array_filter($_POST);
    $amember = $data_to_store['amember'] ?? '';
    
    // Check for duplicate request using file-based locking
    if (isDuplicateRequest($amember)) {
        echo "[OK]"; // Return OK but don't deduct credit
        exit;
    }
    
    $db->where('amember', $amember);
    $charges = $db->getOne("charges");
    $db = getDbInstance();
    $left = $totallimit;
    
    if (!$charges) {
        $last_id = $db->insert('charges', array(
            "amember" => $amember,
            'total' => $totallimit,
            'charges' => $totallimit,
            'last_recharge' => time()
        ));
        $left = $totallimit;
    } else {
        $left = $charges['charges'];
    }
    
    if ($left > 0) {
        $data_to_store['charges'] = $left;
        $data_to_store['when'] = time();
        $db->insert('actions', $data_to_store);
        $left = $left - 1;
        $db = getDbInstance();
        $db->where('amember', $amember);
        $db->update('charges', array(
            "charges" => $left
        ));
        
        error_log("API: Credit deducted for: " . $amember . " | Remaining: " . $left);
        echo "[OK]";
    } else {
        error_log("API: No credits left for: " . $amember);
        echo "[NO_CREDITS]";
    }
} elseif (isset($_GET['amember'])) {
    $amember = $_GET['amember'];
    $db->where('amember', $amember);
    $charges = $db->getOne("charges");
    $left = $totallimit;
    
    if (!$charges) {
        $last_id = $db->insert('charges', array(
            "amember" => $amember,
            'total' => $totallimit,
            'charges' => $totallimit,
            'last_recharge' => time()
        ));
        $left = $totallimit;
    } else {
        $left = $charges['charges'];
    }
    
    error_log("API: Credit check for: " . $amember . " | Credits: " . $left);
    echo $left;
}
?>