<?php

require_once("CookiesManager.php");

function isJson($string) {
  try {
   json_decode($string);
   return (json_last_error() == JSON_ERROR_NONE);
  } catch (exception $e) {
   return false;
  }
}

function getConfig() {
  if (!file_exists("./config.json"))
    return false;
  $config = file_get_contents("./config.json");
  if (!isJson($config))
    return false;
  return json_decode($config);
}

function localCurl($url, $post) {
  $curl = curl_init();
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($curl, CURLOPT_URL, $url);
  curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 0);
  curl_setopt($curl, CURLOPT_TIMEOUT, 400); //timeout in seconds

  if ($post) {
    curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode((array) $post));
  }

  $resp = curl_exec($curl);
  curl_close($curl);
  return $resp;
}

function toLog($txt) {
  global $path;
  echo "$txt<br>\n";
  file_put_contents($path."/url.log", $txt."\n", FILE_APPEND);
}

// Initialize variables
$message = '';
$url = '';
$path = '';

// Get config
$config = getConfig();
if ($config) {
  $path = $config->path;
  $pathaccs = $config->pathaccs;
  $THIS_DOMAIN = $config->domain;
  $cfbypassProxy = $config->cfbypassProxy;
  $cfbypassAPI = "http://".str_replace("5958", "5959", $config->cfbypassProxy);
}

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['tfa_url'])) {
  $url = trim($_POST['tfa_url']);
  
  if (!empty($url)) {
    // Validate URL format
    if (filter_var($url, FILTER_VALIDATE_URL)) {
      // Send URL to Windows server
      $response = localCurl($cfbypassAPI, [
        "type" => base64_encode("openurl"),
        "url" => base64_encode($url)
      ]);
      
      toLog("Submitted 2FA URL: " . $url);
      toLog("Response: " . $response);
      
      // Parse response
      if (isJson($response)) {
        $responseObj = json_decode($response);
        if (isset($responseObj->success) && $responseObj->success === true) {
          $message = '<div class="success">URL successfully opened in browser!</div>';
        } else {
          $error = isset($responseObj->error) ? $responseObj->error : "Unknown error";
          $message = '<div class="error">Error: ' . $error . '</div>';
        }
      } else {
        $message = '<div class="error">Error: Invalid response from server</div>';
      }
    } else {
      $message = '<div class="error">Error: Please enter a valid URL</div>';
    }
  } else {
    $message = '<div class="error">Error: Please enter a URL</div>';
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ahrefs 2FA URL Submission</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            background-color: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        h1 {
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 3px;
            font-size: 16px;
        }
        button {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 3px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #45a049;
        }
        .success {
            background-color: #dff0d8;
            color: #3c763d;
            padding: 10px;
            border-radius: 3px;
            margin-bottom: 15px;
        }
        .error {
            background-color: #f2dede;
            color: #a94442;
            padding: 10px;
            border-radius: 3px;
            margin-bottom: 15px;
        }
        .info {
            background-color: #d9edf7;
            color: #31708f;
            padding: 10px;
            border-radius: 3px;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Ahrefs 2FA URL Submission</h1>
        
        <div class="info">
            Enter the 2FA verification URL from Ahrefs to complete the login process. 
            This URL will be opened in the browser session that is waiting for verification.
        </div>
        
        <?php echo $message; ?>
        
        <form method="post" action="">
            <div class="form-group">
                <label for="tfa_url">2FA Verification URL:</label>
                <input type="text" id="tfa_url" name="tfa_url" placeholder="https://app.ahrefs.com/user/verify/..." value="<?php echo htmlspecialchars($url); ?>" required>
            </div>
            
            <button type="submit">Submit URL</button>
        </form>
    </div>
</body>
</html>