<?php
// Define directories to clean
$directories = [
    __DIR__ . '/cache/',
    __DIR__ . '/cache_html/'
];

// Define specific files to delete
$specificFiles = [
    __DIR__ . '/account_1/auth.required'
];

$totalDeleted = 0;

// Loop through each directory
foreach ($directories as $directory) {
    // Check if directory exists
    if (!is_dir($directory)) {
        echo "Directory not found: " . $directory . "\n";
        continue;
    }
    
    // Get all files in the directory
    $files = glob($directory . '*');
    
    // Delete each file
    foreach ($files as $file) {
        if (is_file($file)) {
            if (unlink($file)) {
                $totalDeleted++;
                echo "Deleted: " . $file . "\n";
            } else {
                echo "Failed to delete: " . $file . "\n";
            }
        }
    }
}

// Delete specific files
foreach ($specificFiles as $file) {
    if (file_exists($file)) {
        if (unlink($file)) {
            $totalDeleted++;
            echo "Deleted specific file: " . $file . "\n";
        } else {
            echo "Failed to delete specific file: " . $file . "\n";
        }
    } else {
        echo "Specific file not found: " . $file . "\n";
    }
}

echo "Successfully deleted " . $totalDeleted . " files total\n";
?>