<?php


error_reporting(E_ALL);
ini_set("log_errors", 1);
ini_set("display_errors", 1);
ini_set("error_log", "./errors.log");

require("CookiesManager.php");


function isJson($string) {
  try {
   json_decode($string);
   return (json_last_error() == JSON_ERROR_NONE);
  } catch (exception $e) {
   return false;
  }
}

function assocArray($arr1, $arr2) {
  $k = 0;
  $arr= Array();
  foreach($arr2 as $kk => $obj) {
    $arr[$kk] = $arr1[$k];
    if ($k == (count($arr1) - 1)) {
      $k = 0;
    } else $k++;
  }
  return $arr;
}

function getProxies() {
  return json_decode(file_get_contents("./proxies.json"));
}
function getConfig() {
  if (!file_exists("./config.json"))
    return false;
  $config = file_get_contents("./config.json");
  if (!isJson($config))
    return false;
  return json_decode($config);
}

function localCurl($url, $post) {
  $curl = curl_init();
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($curl, CURLOPT_URL, $url);
  curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 0);
  curl_setopt($curl, CURLOPT_TIMEOUT, 400); //timeout in seconds

  if ($post) {
    curl_setopt($curl, CURLOPT_HTTPHEADER,array('Content-Type: application/json'));
    curl_setopt( $curl, CURLOPT_POSTFIELDS, json_encode((array) $post) );
  }

  $resp = curl_exec($curl);
  curl_close($curl);
  return $resp;
}

$pathaccs = ".";
$acc = "account_1";
$error = "";
$success = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $uploadDir = 'uploads/';
    $allowedTypes = ['application/json', 'text/plain'];
    $maxFileSize = (1024 * 1024) * 30; // 30MB

    if (isset($_FILES['json_file']) && $_FILES['json_file']['error'] === UPLOAD_ERR_OK) {
        $fileInfo = $_FILES['json_file'];

        // Validate file type
        if (!in_array($fileInfo['type'], $allowedTypes)) {
            $error = 'Error: Only JSON files are allowed.';
        } else {

            $tempPath = $fileInfo['tmp_name'];
            $content = file_get_contents($tempPath);
            $data = json_decode($content, true);

            if (json_last_error() === JSON_ERROR_NONE) {
                $config = getConfig();
                if ($config) {
                  $proxies = getProxies();
                  $accsProxies = assocArray($proxies, [$acc]);

                  $resetedResp = localCurl("http://".str_replace("5958", "5959", $config->cfbypassProxy)."/reset", [
                    "url" => base64_encode($config->target),
                    "proxy" => base64_encode($accsProxies[0])
                  ]);
                  echo "Reset: ".json_encode($resetedResp)."<br>\n";
                }

                $success = true;
                $jsonContent = $content;
                $decodedData = isset(((object)$data)->cookies) ? (object)$data : (object)[
                  "cookies" => $data
                ];

                $cookiesManager = new CookiesManager($pathaccs.'/'.$acc.'/cookies.file');
                $cookiesManager->empty();
                $allcook = [];
                $newcook = [];


                foreach($decodedData->cookies as $a) {
                  $c = (object)$a;
                  $addcook = $c->name."=".$c->value;
                  if (isset($c->expirationDate))
                    $addcook .= "; expires=".date('D j-M-Y H:i:s', intval($c->expirationDate))." GMT";
                  $addcook .= "; Max-Age=0";
                  if (isset($c->path))
                    $addcook .= "; path=".$c->path;
                  if (isset($c->domain))
                    $addcook .= "; domain=".$c->domain;
                  if (isset($c->sameSite)) {
                    if ($c->sameSite == 'no_restriction')
                      $c->sameSite = 'none';
                    $addcook .= "; sameSite=".$c->sameSite;
                  }
                  $addcook .= ";";
                  $allcook[] = $addcook;
                  $newcook[] = (object)[
                    "name" => $c->name,
                    "value" => $c->value,
                    "domain" => $c->domain,
                    "path" => $c->path,
                    "expires" => (isset($c->expirationDate) ? intval($c->expirationDate) : -1),
                    "httpOnly" => $c->httpOnly,
                    "secure" => $c->secure,
                    "sameSite" => ucfirst($c->sameSite)
                  ];
                }

                $cookiesManager->update($allcook);
                file_put_contents($pathaccs."/".$acc . '/cookies.json', json_encode($newcook));
                file_put_contents($pathaccs."/".$acc . '/ua.txt', '');
                file_put_contents($pathaccs."/".$acc . '/main.html', '');
                file_put_contents($pathaccs."/".$acc . '/localStorage.json', "{}");
                file_put_contents($pathaccs."/".$acc . '/auth.json', "{}");
                @unlink("./cache_html");
                @mkdir("./cache_html");
            } else {
                $error = 'Error: Invalid JSON format - ' . json_last_error_msg();
            }
        }
    } else {
        $error = 'Error: Please select a valid file to upload.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cookies importer</title>
    <style>
        .container { max-width: 800px; margin: 20px auto; padding: 20px; }
        .form-group { margin-bottom: 15px; }
        .error { color: #dc3545; }
        .success { color: #28a745; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Upload Cookies JSON File</h1>

        <form action="" method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <input type="file" name="json_file" accept=".json,application/json">
            </div>
            <div class="form-group">
                <button type="submit">Upload and Process</button>
            </div>
        </form>

        <?php if ($error != ""): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if ($success === true): ?>
            <div class="success">
                <h3>File successfully processed!</h3>
                <h4>Raw JSON:</h4>
                <pre><?php echo htmlspecialchars($jsonContent); ?></pre>

                <h4>Decoded Data:</h4>
                <pre><?php print_r($decodedData); ?></pre>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
