function downloadCSV(csvContent, fileName) {
    // Create a link to download the CSV
    var encodedUri = encodeURI("data:text/csv;charset=utf-8," + csvContent);
    var link = document.createElement("a");
    link.setAttribute("href", encodedUri);
    link.setAttribute("download", fileName);
    document.body.appendChild(link); // Required for FF

    link.click(); // Trigger the download
    document.body.removeChild(link); // Clean up
}

function extractTableToCSV() {
    // Select the table element based on its unique class
    var table = document.querySelector('.css-18gur7r-table');
    var rows = table.querySelectorAll('tr');
    var csvContent = "";

    // Iterate through rows
    rows.forEach(function (row) {
        var cells = row.querySelectorAll('th, td');
        var rowContent = [];
        cells.forEach(function (cell) {
            var text = cell.innerText.replace(/(\r\n|\n|\r|,)/gm, ""); // Clean cell text
            rowContent.push('"' + text + '"'); // Wrap in quotes to handle commas in data
        });
        csvContent += rowContent.join(',') + "\r\n"; // End of row
    });

    return csvContent;
}

var csvData = extractTableToCSV();
downloadCSV(csvData, "downloaded_data.csv");
