var width;
var height;
var streamReady;

width = window.innerWidth
  || document.documentElement.clientWidth
  || document.body.clientWidth;

height = window.innerHeight
  || document.documentElement.clientHeight
  || document.body.clientHeight;

var my2ndEfficientFn = debounce(function() {
    if(streamReady==true){
        video.play();
    }
}, 1000);

window.addEventListener('resize', myEfficientFn);

var mainstream = new MediaStream();
var video = document.getElementById('video');
var command = {};
var client = null;
var listeners = [];
function sendMouseEvent(event) {

    command = {
        command: event.type,
        x: event.layerX,
        y: event.layerY,
        width: video.videoWidth,
        height: video.videoHeight,
        button: event.button
    }
    window.ws.send(JSON.stringify(command));
}

function sendMouseEventAlt(event) {
    command = {
        command: event.type,
        x: event.layerX,
        y: event.layerY,
        deltaX: event.deltaX,
        deltaY: -event.deltaY,
        width: video.videoWidth,
        height: video.videoHeight,
        button: event.button
    }
    window.ws.send(JSON.stringify(command));
}

async function sendKeydownEvent(event) {
    event.preventDefault();
    if(event.key=="F4"){ sendFunctionKeyEvent(event);}
    var modifiers = [];
    if (event.ctrlKey && event.key.toLowerCase() == 'v') {
      const clipboard = await navigator.clipboard.readText();
      command = {
          command: "paste",
          text: clipboard
      }
      window.ws.send(JSON.stringify(command));
      return false;
    }
    if(event.altKey) modifiers.push("alt");
    if(event.ctrlKey) modifiers.push("ctrl");
    if(event.metaKey) modifiers.push("meta");
    if(event.shiftKey) modifiers.push("shift");
    command = {
        command: "keypress",
        keyCode: event.key,
        code: event.keyCode,
        modifiers: modifiers
    }
    window.ws.send(JSON.stringify(command));
}


function sendKeyupEvent(event) {
    event.preventDefault();
    if(event.key=="F4"){ sendFunctionKeyEvent(event);}
    var modifiers = [];
    if(event.altKey) modifiers.push("alt");
    if(event.ctrlKey) modifiers.push("ctrl");
    if(event.metaKey) modifiers.push("meta");
    if(event.shiftKey) modifiers.push("shift");

    command = {
        command: "keyup",
        keyCode: event.key,
        code: event.keyCode,
        modifiers: modifiers
    }
    window.ws.send(JSON.stringify(command));
}

function sendFunctionKeyEvent(event) {
    command = {
        command: "functionkey",
        keyCode: event.key,
        code: event.keyCode,
        modifiers: ""
    }
    window.ws.send(JSON.stringify(command));
}

var saveByteArray = (function () {
    var a = document.createElement("a");
    document.body.appendChild(a);
    a.style = "display: none";
    return function (data, name) {
        var blob = new Blob(data, {type: "octet/stream"}),
            url = window.URL.createObjectURL(blob);
        a.href = url;
        a.download = name;
        a.click();
        window.URL.revokeObjectURL(url);
    };
}());

window.ws.onmessage = async function(event) {
    var msg = JSON.parse(event.data);
    if (msg.download) {
      const byteCharacters = atob(msg.download);
      const byteNumbers = new Array(byteCharacters.length);
      for (let i = 0; i < byteCharacters.length; i++) {
          byteNumbers[i] = byteCharacters.charCodeAt(i);
      }
      const byteArray = new Uint8Array(byteNumbers);
      saveByteArray([byteArray], msg.filename);
      return;
    }
    if (msg.copy) {
      await navigator.clipboard.writeText(msg.copy);
      return;
    }
    if (msg.cursor) {
      $('body').css('cursor', msg.cursor);
      return;
    }
    switch(msg.command) {
        case "newurl":
          history.pushState({}, null, msg.url);
          break;
        case "webrtc-config":
            client = new StreamClient(msg.config);
            listeners.push(video.addEventListener('mousedown', sendMouseEvent, false));
            listeners.push(video.addEventListener('mouseup', sendMouseEvent, false));
            listeners.push(video.addEventListener('mousemove', sendMouseEvent, false));
            listeners.push(video.addEventListener('mousemove', my2ndEfficientFn, false));
            listeners.push(video.addEventListener('mouseenter', sendMouseEvent, false));
            listeners.push(video.addEventListener('mousewheel', sendMouseEventAlt, false));
            listeners.push(document.addEventListener('keydown', sendKeydownEvent, false));
//            listeners.push(document.addEventListener('keyup', sendKeyupEvent, false));
            break;
        case "ready":
            video.srcObject = client.getStream();
            streamReady = true;
            requestResize(width, height);
            video.play();
            break;
    }
}

function clearListeners(item) {
    try{video.removeEventListener(item);} catch(e){}
    try{document.removeEventListener(item);} catch(e){}
};


window.ws.addEventListener('close', function (event) {
    listeners.forEach(clearListeners)
    video.srcObject = null;
    video.play();
    streamReady = false;

});



function StreamClient(config) {
    let that = this;
    this.offerOptions = {}
    this.peer = new RTCPeerConnection({ iceServers: [{ urls: 'stun:'+window.location.hostname+':3478' }]});
    this.peer.setConfiguration({ iceServers: [{ urls: 'stun:'+window.location.hostname+':3478' }]});
    this.peer.onicecandidate = function(e) {that.icecandidates.push(e.candidate);}
    this.sdp = null;
    this.icecandidates = [];
    this.peer.setRemoteDescription(config.sdp);
    this.peer.createAnswer().then(desc => {
        that.peer.setLocalDescription(desc);
        that.sdp = desc;
        config.icecandidates.forEach( function(candidate) {
            if(candidate != null || candidate != undefined) {
                let rtcicecandidate = new RTCIceCandidate(candidate);
                that.peer.addIceCandidate(rtcicecandidate)
                .then( function(s) {}, function(e) {console.log('Error whileadding RTCIceCandidate ' + e) } )
            }
        })
        setTimeout(this.monitorGatheringState, 500);
    })
}
StreamClient.prototype.getStream = function () {
    return this.peer.getRemoteStreams()[0];
}
StreamClient.prototype.monitorGatheringState = function () {
    if(client.peer.iceGatheringState == "complete") {
        let message = {
                command: "webrtc-config",
                config: {
                    sdp: client.sdp,
                    icecandidates: client.icecandidates
                }
            }
        window.ws.send(JSON.stringify(message));
    } else {
        setTimeout(client.monitorGatheringState, 100);
    }
}

document.oncontextmenu = document.body.oncontextmenu = function() {return false;}