<?php

require("CookiesManager.php");

function randUA() {
  $uas = explode("\n",file_get_contents("uas.txt"));
  return $uas[array_rand($uas)];
}

function randProxy() {
  global $proxies;
  return $proxies[array_rand($proxies)];
}

function isJson($string) {
  try {
   json_decode($string);
   return (json_last_error() == JSON_ERROR_NONE);
  } catch (exception $e) {
   return false;
  }
}

function listAccount() {
  global $pathaccs;
  $d = dir($pathaccs."/");
  $accs = Array();
  while(false !== ($entry = $d->read())) {
    if (strstr($entry, "account_"))
      $accs[] = $entry;
  }
  $d->close();
  return $accs;
}

function doPost($cookiesManager, $proxy, $acc, $ua, $url, $referer = false, $post = false, $bearer = false) {
  global $pathaccs, $cfbypassProxy;
  toLog("[$acc] $proxy request: ".($post ? "POST" : "GET")." ".$url.($post ? "\nData: ".json_encode($post) : '').($bearer ? "\nBearer: ".$bearer : ""));
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($curl, CURLOPT_URL, $url);
	//curl_setopt($curl, CURLOPT_URL, str_replace("https://", "http://", $url));
	//curl_setopt($curl, CURLOPT_COOKIEJAR, $pathaccs.'/'.$acc.'/cookies.txt');
	//url_setopt($curl, CURLOPT_COOKIEFILE, $pathaccs.'/'.$acc.'/cookies.txt');
	curl_setopt($curl, CURLOPT_PROXYPORT, "32421");
	curl_setopt($curl, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
	curl_setopt($curl, CURLOPT_PROXY, "38.79.101.70");
  curl_setopt($curl, CURLOPT_CONNECTTIMEOUT,15);
  curl_setopt($curl, CURLOPT_HTTPPROXYTUNNEL, 1);
  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
  curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	//curl_setopt($curl, CURLOPT_PROXYUSERPWD, "haseebx2010:E2A85FDC015A9A03358FE4F9C6A483A1");
  //curl_setopt($curl, CURLOPT_PROXY, $cfbypassProxy);
  curl_setopt($curl, CURLOPT_HEADER, 1);
  //["https://haseebx2010:E2A85FDC015A9A03358FE4F9C6A483A1@38.79.90.196:12440","https://haseebx2010:E2A85FDC015A9A03358FE4F9C6A483A1@38.79.91.29:12440", "https://haseebx2010:E2A85FDC015A9A03358FE4F9C6A483A1@38.79.100.126:32421"]
  $headers = array(
    "User-Agent: ". ($ua && $ua != "" ? $ua : 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/535.36 (KHTML, like Gecko) Chrome/91.0.4433.0 Safari/537.36'),
    "Referer: ". ($referer ? $referer : "https://www.google.com")
  );
  $f = null;
  $cooks = $cookiesManager->get();
  if ($cooks && $cooks != "" && !$post && !$token) {
    $headers[] = "Cookie: ".$cooks;
  }
  if (!$post && !$token) {
    $headers[] = "Accept-Language: en-US,en;q=0.5";
    $headers[] = "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8";
    $headers[] = "Accept-Encoding: gzip, deflate, br";
    $headers[] = "Connection: keep-alive";
    $headers[] = "Upgrade-Insecure-Requests: 1";
    $headers[] = "Pragma: no-cache";
    $headers[] = "Cache-Control: no-cache";
    $headers[] = "TE: Trailers";
    $headers[] = "sec-fetch-dest: empty";
    $headers[] = "sec-fetch-mode: cors";
    $headers[] = "sec-fetch-site: cross-site";
  }

  $f = tmpfile();
  curl_setopt($curl, CURLOPT_VERBOSE, 1);
  curl_setopt($curl, CURLOPT_STDERR, $f);

	if ($post) {
		array_push($headers, 'Content-Type: application/json');
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode((array) $post));
	}

	if ($bearer && $bearer != "") {
		array_push($headers, 'Authorization: Bearer ' . $bearer);
	}

	if (count($headers) > 0)
		curl_setopt($curl, CURLOPT_HTTPHEADER,$headers);

  //toLog("Sending headers: ".json_encode($headers));
	$resp = curl_exec($curl);
  //toLog("Response: ".$resp);
  $isredirect = false;
  $curl_info = curl_getinfo($curl);
  $header_size = $curl_info['header_size'];
  $headersx = explode("\n",substr($resp, 0, $header_size));
  $responseBody = substr($resp, $header_size);
  $headers = Array();
  foreach($headersx as $h) {
    $fixh = explode(":", $h);
    $ht = strtolower($fixh[0]);
    unset($fixh[0]);
    $hr = join(":", $fixh);
    if ($headers[$ht]) {
      $headers[$ht] = [$headers[$ht], $hr];
    } else {
      $headers[$ht] = $hr;
    }
  }

  $responseBody = gzdecode($responseBody);

  $saveHeaders = Array();
  if (isset($headers["set-cookie"])) {
    if (strstr($headers["set-cookie"], "\n")) {
      foreach(split("\n", $headers["set-cookie"]) as $c) {
        $saveHeaders[] = $c;
      }
    } else {
      $saveHeaders[] = $headers["set-cookie"];
    }
    $cookiesManager->update($saveHeaders);
  }

  if($curl_info['url'] != $url) {
    $isredirect = $curl_info['url'];
  }

  if ($f) {
    fseek($f, 0);
    echo fread($f, 32*1024); # output up to 32 KB cURL verbose log
    fclose($f);
  }

  $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

  /*
  if ( strlen($resp) && (curl_errno($curl)==CURLE_OK) && ($httpcode==200) ) {
      // check for gzipped content
      if ( (ord($resp[0])==0x1f) && (ord($resp[1])==0x8b) ) {
          // skip header and ungzip the data
          $resp = gzinflate(substr($resp,10));
      }
  }
  */

	curl_close($curl);
	return $responseBody;
}

function justUpdate($id, $acc) {
  global $pathaccs, $accsProxies, $path, $THIS_DOMAIN, $cfbypassAPI;
  $ua = randUA();

  if (!file_exists($pathaccs."/".$acc."/auth.required") && file_exists($pathaccs.'/'.$acc.'/cookies.json')) {
    toLog("Account $acc needs no auth");
    return false;
  }
  $cookiesManager = new CookiesManager($pathaccs.'/'.$acc.'/cookies.file');

  if (!file_exists($pathaccs."/".$acc."/auth.json")) {
    toLog("Account $acc has no auth.json");
    return false;
  }

  $loginInfo = file_get_contents($pathaccs."/".$acc."/auth.json");
  if (!isJson($loginInfo)) {
    toLog("Account $acc bad json");
    return false;
  }

  try {
    @unlink($pathaccs."/".$acc . '/cookies.file');
    @unlink($pathaccs."/".$acc . '/cookies.json');
    @unlink($pathaccs."/".$acc . '/localStorage.json');
    @unlink($pathaccs."/".$acc . '/main.html');
    @unlink($pathaccs."/".$acc . '/ua.txt');
    $loginInfo = json_decode($loginInfo);
    $cookiesManager = new CookiesManager($pathaccs.'/'.$acc.'/cookies.file');
    toLog("[$acc] Logging in...".json_encode($loginInfo));
    $cfbypassed = localCurl($cfbypassAPI, [
      "type" => base64_encode("ahreflogin"),
      "fromurl" => base64_encode($THIS_DOMAIN),
      "proxy" => base64_encode($accsProxies[$id]),
      "userag" => base64_encode($ua),
      "username" => base64_encode($loginInfo->username),
      "password" => base64_encode($loginInfo->password)
    ]);
    
    toLog("[$acc] Server response: ".$cfbypassed);
    $cfbypassed = json_decode($cfbypassed);

    if (@$cfbypassed->error) {
      toLog("[$acc] Error: ".$cfbypassed->error);
      return false;
    }

    if (@$cfbypassed->working) {
      toLog("[$acc] Status: working...");
      return false;
    }

    // Check for specific login failures
    if (isset($cfbypassed->message) && strpos($cfbypassed->message, 'Login not found') !== false) {
      toLog("[$acc] Login failed: Invalid credentials or account not found");
      toLog("[$acc] Username: ".$loginInfo->username);
      toLog("[$acc] Please verify the credentials in auth.json");
      return false;
    }

    if (!isset($cfbypassed->cookies) && !isset($cfbypassed->body)) {
      toLog("[$acc] Unexpected response structure: ".json_encode($cfbypassed));
      return false;
    }

    // Store new cookies
    if (@$cfbypassed->cookies) {
      $cookiesManager->empty();
      $allcook = [];
      foreach($cfbypassed->cookies as $c) {
        //login_session=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; Max-Age=0; path=/;
        $addcook = $c->name."=".$c->value;
        if (isset($c->expires))
          $addcook .= "; expires=".date('D j-M-Y H:i:s', $c->expires)." GMT";
        $addcook .= "; Max-Age=0";
        if (isset($c->path))
          $addcook .= "; path=".$c->path;
        if (isset($c->domain))
          $addcook .= "; domain=".$c->domain;
        if (isset($c->sameSite))
          $addcook .= "; sameSite=".$c->sameSite;
        $addcook .= ";";
        $allcook[] = $addcook;
      }

      $cookiesManager->update($allcook);
      file_put_contents($pathaccs."/".$acc . '/cookies.json', json_encode($cfbypassed->cookies));
    }
    if (@$cfbypassed->ua) {
      file_put_contents($pathaccs."/".$acc . '/ua.txt', @$cfbypassed->ua);
    }
    if (@$cfbypassed->body) {
      file_put_contents($pathaccs."/".$acc . '/main.html', $cfbypassed->body);
    }
    if (@$cfbypassed->localStorage) {
      file_put_contents($pathaccs."/".$acc . '/localStorage.json', json_encode($cfbypassed->localStorage));
    }
    @unlink($pathaccs."/".$acc . '/auth.required');
    toLog("[$acc] Logged in!");
  } catch (exception $e) {
    toLog($pathaccs." Error CFBypass: ".$e->getMessage());
    echo "Try again later...";
  }
}

function extractBetween($start, $end, $str){
    $matches = array();
    $regex = "/$start([a-zA-Z0-9_\-\.\~]*)$end/";
    preg_match_all($regex, $str, $matches);
    return $matches[1];
}

function localCurl($url, $post) {
  $curl = curl_init();
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($curl, CURLOPT_URL, $url);
  curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 0);
  curl_setopt($curl, CURLOPT_TIMEOUT, 400); //timeout in seconds

  if ($post) {
    curl_setopt($curl, CURLOPT_HTTPHEADER,array('Content-Type: application/json'));
    curl_setopt( $curl, CURLOPT_POSTFIELDS, json_encode((array) $post) );
  }

  $resp = curl_exec($curl);
  curl_close($curl);
  return $resp;
}

function toLog($txt) {
  global $path;
  echo "$txt<br>\n";
  toLogFile($txt);
}

function toLogFile($txt) {
  global $path;
  if ($path && $path != "") {
    file_put_contents($path."/auth.log", $txt."\n", FILE_APPEND);
  } else {
    file_put_contents("./auth.log", $txt."\n", FILE_APPEND);
  }
}

function assocArray($arr1, $arr2) {
  $k = 0;
  $arr= Array();
  foreach($arr2 as $kk => $obj) {
    $arr[$kk] = $arr1[$k];
    if ($k == (count($arr1) - 1)) {
      $k = 0;
    } else $k++;
  }
  return $arr;
}

function getProxies() {
  global $path;
  return json_decode(file_get_contents($path."/proxies.json"));
}

function delProxy($proxy) {
  global $path;
  $proxies = getProxies();
  $reProxies = [];
  foreach($proxies as $prox) {
    if ($proxy != $prox)
      $reProxies[] = $prox;
  }
  file_put_contents($path."/proxies.json", json_encode($reProxies));
}

function getConfig() {
  if (!file_exists("./config.json"))
    return false;
  $config = file_get_contents("./config.json");
  if (!isJson($config))
    return false;
  return json_decode($config);
}

// NEW FUNCTION: Handle authentication request creation
function handleAuthRequest() {
  global $pathaccs;
  
  // Check if create_auth action is requested
  if (isset($_GET['action']) && $_GET['action'] === 'create_auth') {
    $accs = listAccount();
    $created = 0;
    $logMessages = [];
    
    foreach ($accs as $acc) {
      $authRequiredPath = $pathaccs."/".$acc."/auth.required";
      
      if (!file_exists($authRequiredPath)) {
        // Create auth.required file with current timestamp
        file_put_contents($authRequiredPath, date('Y-m-d H:i:s'));
        $logMessages[] = "Created auth.required for account: $acc";
        $created++;
      }
    }
    
    if ($created > 0) {
      // Log the messages after redirect
      foreach ($logMessages as $msg) {
        toLogFile($msg);
      }
      
      // Use JavaScript redirect to avoid header issues
      echo "<!DOCTYPE html>";
      echo "<html><head><title>Authentication Created</title>";
      echo "<style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; text-align: center; }
        .container { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); max-width: 600px; margin: 0 auto; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 20px; margin: 20px 0; border-radius: 4px; }
      </style>";
      echo "<meta http-equiv='refresh' content='3;url=" . $_SERVER['PHP_SELF'] . "'>";
      echo "</head><body>";
      echo "<div class='container'>";
      echo "<div class='success'>";
      echo "✓ Authentication request created for $created account(s).<br>";
      echo "The script will now proceed with authentication...<br>";
      echo "<small>Redirecting in 3 seconds...</small>";
      echo "</div>";
      echo "</div>";
      echo "</body></html>";
      exit();
    } else {
      echo "<div style='background: #fff3cd; border: 1px solid #ffeaa7; color: #856404; padding: 10px; margin: 10px 0; border-radius: 4px;'>";
      echo "⚠ All accounts already have authentication requests.";
      echo "</div>";
    }
  }
}

// NEW FUNCTION: Handle custom URL request
function handleCustomURL() {
  global $cfbypassAPI, $accsProxies, $accs;
  
  if (isset($_POST['action']) && $_POST['action'] === 'custom_url') {
    $customURL = $_POST['custom_url'];
    $selectedAccount = $_POST['account'];
    $requestType = $_POST['request_type'];
    
    if (!empty($customURL) && !empty($selectedAccount)) {
      $ua = randUA();
      $accountIndex = array_search($selectedAccount, $accs);
      
      if ($accountIndex !== false) {
        $proxy = $accsProxies[$accountIndex];
        
        echo "<div style='background: #e7f3ff; border: 1px solid #b8daff; color: #004085; padding: 15px; margin: 10px 0; border-radius: 4px;'>";
        echo "📤 Sending custom request to Node.js server...<br>";
        echo "URL: $customURL<br>";
        echo "Account: $selectedAccount<br>";
        echo "Type: $requestType<br>";
        echo "</div>";
        
        $payload = [
          "type" => base64_encode($requestType),
          "url" => base64_encode($customURL),
          "proxy" => base64_encode($proxy),
          "userag" => base64_encode($ua),
          "account" => base64_encode($selectedAccount)
        ];
        
        toLog("Sending custom URL request: ".json_encode($payload));
        
        $response = localCurl($cfbypassAPI, $payload);
        
        echo "<div style='background: #f8f9fa; border: 1px solid #dee2e6; padding: 15px; margin: 10px 0; border-radius: 4px;'>";
        echo "<strong>Server Response:</strong><br>";
        echo "<pre style='background: #212529; color: #fff; padding: 10px; border-radius: 4px; overflow-x: auto;'>";
        echo htmlspecialchars($response);
        echo "</pre>";
        echo "</div>";
        
        toLog("Custom URL response: ".$response);
      } else {
        echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 10px; margin: 10px 0; border-radius: 4px;'>";
        echo "❌ Invalid account selected.";
        echo "</div>";
      }
    }
  }
}

// NEW FUNCTION: Display custom URL form
function displayCustomURLForm() {
  global $accs;
  
  if (isset($_GET['show_form']) && $_GET['show_form'] === 'true') {
    echo "<!DOCTYPE html>";
    echo "<html><head><title>Custom URL Tester</title>";
    echo "<style>
      body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
      .container { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); max-width: 800px; margin: 0 auto; }
      .form-group { margin: 15px 0; }
      label { display: block; margin-bottom: 5px; font-weight: bold; }
      input[type='text'], input[type='url'], select, textarea { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; }
      .btn { background: #007bff; color: white; padding: 12px 24px; border: none; border-radius: 4px; cursor: pointer; font-size: 14px; }
      .btn:hover { background: #0056b3; }
      .btn-secondary { background: #6c757d; }
      .btn-secondary:hover { background: #545b62; }
      .info { background: #d1ecf1; border: 1px solid #bee5eb; color: #0c5460; padding: 15px; border-radius: 4px; margin: 20px 0; }
      .example { background: #f8f9fa; border: 1px solid #dee2e6; padding: 10px; border-radius: 4px; font-family: monospace; font-size: 12px; }
    </style></head>";
    echo "<body>";
    echo "<div class='container'>";
    echo "<h2>🔧 Custom URL Tester</h2>";
    echo "<p>Send custom requests to your Node.js server for testing and debugging.</p>";
    
    echo "<div class='info'>";
    echo "<strong>Usage:</strong> This tool allows you to test different URLs and request types with your Node.js server using the same proxy and user agent configuration as your accounts.";
    echo "</div>";
    
    echo "<form method='post' action='".$_SERVER['PHP_SELF']."'>";
    echo "<input type='hidden' name='action' value='custom_url'>";
    
    echo "<div class='form-group'>";
    echo "<label for='custom_url'>URL to Test:</label>";
    echo "<input type='url' id='custom_url' name='custom_url' placeholder='https://example.com/page' required>";
    echo "</div>";
    
    echo "<div class='form-group'>";
    echo "<label for='account'>Select Account (for proxy assignment):</label>";
    echo "<select id='account' name='account' required>";
    echo "<option value=''>-- Select Account --</option>";
    foreach($accs as $acc) {
      echo "<option value='$acc'>$acc</option>";
    }
    echo "</select>";
    echo "</div>";
    
    echo "<div class='form-group'>";
    echo "<label for='request_type'>Request Type:</label>";
    echo "<select id='request_type' name='request_type' required>";
    echo "<option value='customtest'>Custom Test</option>";
    echo "<option value='ahreflogin'>Ahrefs Login</option>";
    echo "<option value='pagecheck'>Page Check</option>";
    echo "<option value='cookietest'>Cookie Test</option>";
    echo "</select>";
    echo "</div>";
    
    echo "<div class='form-group'>";
    echo "<button type='submit' class='btn'>Send Request</button>";
    echo "<a href='".$_SERVER['PHP_SELF']."' class='btn btn-secondary' style='margin-left: 10px; text-decoration: none;'>Back to Auth</a>";
    echo "</div>";
    
    echo "</form>";
    
    echo "<div class='example'>";
    echo "<strong>Example URLs to test:</strong><br>";
    echo "• https://httpbin.org/ip (Check IP through proxy)<br>";
    echo "• https://httpbin.org/user-agent (Check User Agent)<br>";
    echo "• https://httpbin.org/cookies (Check Cookies)<br>";
    echo "• https://ahrefs.com/login (Test Ahrefs login page)<br>";
    echo "• https://www.google.com (Basic connectivity test)";
    echo "</div>";
    
    echo "</div>";
    echo "</body></html>";
    exit();
  }
}
function checkAuthRequired() {
  global $pathaccs;
  
  $accs = listAccount();
  $needsAuth = false;
  
  foreach ($accs as $acc) {
    $authRequiredPath = $pathaccs."/".$acc."/auth.required";
    
    if (!file_exists($authRequiredPath)) {
      $needsAuth = true;
      break;
    }
  }
  
  if ($needsAuth) {
    echo "<!DOCTYPE html>";
    echo "<html><head><title>Authentication Required</title>";
    echo "<style>
      body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; }
      .container { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); max-width: 600px; margin: 0 auto; }
      .btn { background: #007bff; color: white; padding: 12px 24px; text-decoration: none; border-radius: 4px; display: inline-block; margin: 10px 0; }
      .btn:hover { background: #0056b3; }
      .info { background: #e9ecef; padding: 15px; border-radius: 4px; margin: 20px 0; }
      .account-list { background: #f8f9fa; padding: 15px; border-radius: 4px; margin: 20px 0; }
      .account { padding: 5px 0; border-bottom: 1px solid #dee2e6; }
      .account:last-child { border-bottom: none; }
    </style></head>";
    echo "<body>";
    echo "<div class='container'>";
    echo "<h2>🔐 Authentication Required</h2>";
    echo "<p>Some accounts are missing authentication requests. Click the button below to create authentication requests for all accounts that need them.</p>";
    
    echo "<div class='info'>";
    echo "<strong>What this does:</strong><br>";
    echo "• Creates auth.required files for accounts that don't have them<br>";
    echo "• Triggers the authentication process for those accounts<br>";
    echo "• Allows the script to proceed with login automation";
    echo "</div>";
    
    echo "<div class='account-list'>";
    echo "<strong>Accounts Status:</strong><br>";
    foreach ($accs as $acc) {
      $authRequiredPath = $pathaccs."/".$acc."/auth.required";
      $status = file_exists($authRequiredPath) ? "✓ Auth request exists" : "⚠ Needs auth request";
      echo "<div class='account'>$acc - $status</div>";
    }
    echo "</div>";
    
    echo "<a href='?action=create_auth' class='btn'>Create Authentication Request</a>";
    echo "</div>";
    echo "</body></html>";
    
    exit();
  }
}

// Check/Update members access
$config = getConfig();

if ($config) {
  $path = $config->path;
  $pathaccs = $config->pathaccs;
  $THIS_DOMAIN = $config->domain;
  $cfbypassProxy = $config->cfbypassProxy;
  $cfbypassAPI = "http://".str_replace("5958", "5959", $config->cfbypassProxy);
}

// Handle authentication request creation if requested
handleAuthRequest();

// Handle custom URL request if submitted
handleCustomURL();

// Display custom URL form if requested
displayCustomURLForm();

// Check if authentication is required before proceeding
checkAuthRequired();

$accs = listAccount();

if (file_exists($path."/working")) {
  die("Working already...\n");
}

file_put_contents($path."/working","1");
set_time_limit(610);
$proxies = getProxies();
$accsProxies = assocArray($proxies, $accs);

foreach ($accs as $id => $acc) {
  toLog("Checking/Updating $acc ($id)");
  justUpdate($id, $acc);
}
@unlink($path."/working");